// item.cpp
// ackmed@gotwalls.com
#include "item.h"
#include "shopbot.h"
#include "MagicPrefix.h"
#include "MagicSuffix.h"
#include "Weapons.h"
#include "TextPatch.h"


ITEMSTRUCT *ParseItemDrop(BYTE *Packet, DWORD Length) {
	ITEMSTRUCT *item = new ITEMSTRUCT;
	TEXTPATCHSTRUCT *tpatch;

	BitFields iPacket(Packet,Length);	

	item->MessageID = iPacket.GetField(8);

	if(item->MessageID != ITEM_MESSAGEID_DROP) {
		delete item;
		return NULL;
	}
	item->Action = iPacket.GetField(8);
	/*  Need to take this out :)
	if(item->Action != ITEM_ACTION_TO_STORE) {
		delete item;
		return NULL;
	}*/
	item->MessageSize = iPacket.GetField(8);
	item->ItemType = iPacket.GetField(8);
	// we only care about weapons / armor

	if(item->ItemType != ITEM_ITEMTYPE_WEAPON && item->ItemType != ITEM_ITEMTYPE_BOW && item->ItemType != ITEM_ITEMTYPE_ARMOR  && item->ItemType != ITEM_ITEMTYPE_HELM && item->ItemType != ITEM_ITEMTYPE_OTHER && item->ItemType != ITEM_ITEMTYPE_SHIELD) {
		delete item;
		return NULL;
	}

	item->ItemID = iPacket.GetField(32);

	// flags
	item->isSocketsFull = iPacket.GetField(1);
	iPacket.GetField(3);
	item->isIdentified = iPacket.GetField(1);
	iPacket.GetField(1);
	item->isSwitchin = iPacket.GetField(1);
	item->isSwitchout = iPacket.GetField(1);
	item->isBroken = iPacket.GetField(1);
	iPacket.GetField(1);
	item->fromBelt = iPacket.GetField(1);
	item->hasSockets = iPacket.GetField(1);
	iPacket.GetField(1);
	item->isJustGenerated = iPacket.GetField(1);
	iPacket.GetField(2);
	item->isEar = iPacket.GetField(1);
	item->isStartitem = iPacket.GetField(1);
	iPacket.GetField(3);
	item->isMiscItem = iPacket.GetField(1);
	item->isEthereal = iPacket.GetField(1);
	iPacket.GetField(1);
	item->isPersonalized = iPacket.GetField(1);
	item->isGamble = iPacket.GetField(1);
	item->isRuneWord = iPacket.GetField(1);
	
	iPacket.GetField(5);
	item->MPQVersionField = iPacket.GetField(10);
	
	item->Location = iPacket.GetField(3);
	iPacket.GetField(4);
	item->PositionX = iPacket.GetField(4);
	item->PositionY = iPacket.GetField(4);
	iPacket.GetField(3);

	// is ear?  not exactly possible  
	if(item->isEar) {
		delete item;
		return NULL;
	}

	if(!item->isIdentified) {
		delete item;
		return NULL;
	}

	// read in itemcode, its a string;
	item->ItemCode[0] = iPacket.GetField(8);
	item->ItemCode[1] = iPacket.GetField(8);
	item->ItemCode[2] = iPacket.GetField(8);
	item->ItemCode[3] = iPacket.GetField(8);
	// chomp off the space if it exists
	if(item->ItemCode[3] == ' ') {
		item->ItemCode[3] = '\0';
	} else {
		item->ItemCode[4] = '\0';
	}
	iPacket.GetField(8);
	iPacket.GetField(2);
	item->ItemLevel = iPacket.GetField(4);

	// only care about magic items.
	if(item->ItemLevel == ITEM_LEVEL_MAGIC) {
		if(item->ItemType == ITEM_ITEMTYPE_WEAPON || item->ItemType == ITEM_ITEMTYPE_BOW || item->ItemType == ITEM_ITEMTYPE_ARMOR  || item->ItemType == ITEM_ITEMTYPE_HELM || item->ItemType == ITEM_ITEMTYPE_OTHER || item->ItemType == ITEM_ITEMTYPE_SHIELD) {
			iPacket.GetField(2);
		}
		WORD row;
		row = iPacket.GetField(11);	 // prefix
		if(row > 0) {
			item->MagicPrefix = GetMagicPrefixRowNumber(row);
			if(item->MagicPrefix != NULL) {
				if(item->MagicPrefix->Prefix == NULL) {
					item->PrefixName[0] = '\0';
					item->MagicPrefix = NULL;
					
				} else {
					tpatch = GetTextPatchKey(item->MagicPrefix->Prefix);
					if(tpatch != NULL && tpatch->Value != NULL) {
						strcpy(item->PrefixName,tpatch->Value);
					} else {
						strcpy(item->PrefixName,item->MagicPrefix->Prefix);
					}
				}
			} else {
				item->PrefixName[0] = '\0';
			}
		} else {
			item->MagicPrefix = NULL;
			item->PrefixName[0] = '\0';
		}

		row = iPacket.GetField(11);	 // suffix
		if(row > 0) {
			item->MagicSuffix = GetMagicSuffixRowNumber(row);
			if(item->MagicSuffix != NULL) {
				if(item->MagicSuffix->Suffix == NULL) {
					item->MagicSuffix = NULL;
					item->SuffixName[0] = '\0';
				} else {
					tpatch = GetTextPatchKey(item->MagicSuffix->Suffix);
					if(tpatch != NULL && tpatch->Value != NULL) {
						strcpy(item->SuffixName,tpatch->Value);
					} else {
						strcpy(item->SuffixName,item->MagicSuffix->Suffix);
					}
				}
			} else {
				item->SuffixName[0] = '\0';
			}

		} else {
			item->MagicSuffix = NULL;
			item->SuffixName[0] = '\0';
		}


		WORD nDefense = 0x00;
		if (item->ItemType == ITEM_ITEMTYPE_ARMOR || item->ItemType == ITEM_ITEMTYPE_HELM || item->ItemType == ITEM_ITEMTYPE_SHIELD || item->ItemType == ITEM_ITEMTYPE_OTHER){
			nDefense = GetBitsAt(Packet, Length, 194, 10) - 10;
		}


		int nDur = 0;
		if (nDefense == 0x00)
			nDur = GetBitsAt(Packet, Length, 194, 8);
		else
			nDur = GetBitsAt(Packet, Length, 204, 8);
		int nAdd = 0;
		if (nDur > 0x00  && (strcmpi(item->SuffixName,"of Ages")<0 || strcmpi(item->SuffixName,"of Ages")>0))
			nAdd = nAdd + 8;
		if (item->hasSockets)
			nAdd = nAdd + 4;
		if (nDefense > 0x00)
			nAdd = nAdd + 10;
		if (strcmpi(item->BaseName,"Balanced Knife") == 0 || strcmpi(item->BaseName,"Throwing Knife") == 0 || strcmpi(item->BaseName,"Throwing Axe") == 0 || strcmpi(item->BaseName,"Balanced Axe") == 0 || strcmpi(item->BaseName,"Javelin") == 0 || strcmpi(item->BaseName,"Pilum") == 0 || strcmpi(item->BaseName,"Short Spear") == 0 || strcmpi(item->BaseName,"Glaive") == 0 || strcmpi(item->BaseName,"Throwing Spear") == 0 || strcmpi(item->BaseName,"Battle Dart") == 0 || strcmpi(item->BaseName,"Francisca") == 0 || strcmpi(item->BaseName,"War Dart") == 0 || strcmpi(item->BaseName,"Hurlbat") == 0 || strcmpi(item->BaseName,"War Javelin") == 0 || strcmpi(item->BaseName,"Great Pilum") == 0 || strcmpi(item->BaseName,"Simbilan") == 0 || strcmpi(item->BaseName,"Spiculum") == 0 || strcmpi(item->BaseName,"Harpoon") == 0 || strcmpi(item->BaseName,"Flying Knife") == 0 || strcmpi(item->BaseName,"Flying Axe") == 0 || strcmpi(item->BaseName,"Winged Knife") == 0 || strcmpi(item->BaseName,"Winged Axe") == 0 || strcmpi(item->BaseName,"Hyperion Javelin") == 0 || strcmpi(item->BaseName,"Stygian Pilum") == 0 || strcmpi(item->BaseName,"Balrog Spear") == 0 || strcmpi(item->BaseName,"Ghost Glaive") == 0 || strcmpi(item->BaseName,"Winged Harpoon") == 0 || strcmpi(item->BaseName,"Maiden Javelin") == 0 || strcmpi(item->BaseName,"Ceremonial Javelin") == 0 || strcmpi(item->BaseName,"MatriarchalJavelin") == 0)
			nAdd = nAdd + 9;






		WORD nEnhanDamage = 0x00;
		if (strcmpi(item->BaseName,"Matriarchal Bow") != 0 && (strcmpi(item->PrefixName,"Sharp")==0 || strcmpi(item->PrefixName,"Fine")==0 || strcmpi(item->PrefixName,"Warrior's")==0 || strcmpi(item->PrefixName,"Soldier's")==0 || strcmpi(item->PrefixName,"Knight's")==0 || strcmpi(item->PrefixName,"Lord's")==0 || strcmpi(item->PrefixName,"King's")==0 || strcmpi(item->PrefixName,"Grandmaster's")==0)){
			nEnhanDamage = GetBitsAt(Packet, Length, nAdd + 230, 9);
			if (((nEnhanDamage > 20 || nEnhanDamage < 10) && strcmpi(item->PrefixName,"Sharp")==0) || ((nEnhanDamage > 30 || nEnhanDamage < 21) && strcmpi(item->PrefixName,"Fine")==0) || ((nEnhanDamage > 40 || nEnhanDamage < 31) && strcmpi(item->PrefixName,"Warrior's")==0) || ((nEnhanDamage > 50 || nEnhanDamage < 41) && strcmpi(item->PrefixName,"Soldier's")==0) || ((nEnhanDamage > 65 || nEnhanDamage < 51) && strcmpi(item->PrefixName,"Knight's")==0) ||  ((nEnhanDamage > 80 || nEnhanDamage < 66) && strcmpi(item->PrefixName,"Lord's")==0) || ((nEnhanDamage > 100 || nEnhanDamage < 81) && strcmpi(item->PrefixName,"King's")==0) || ((nEnhanDamage > 150 || nEnhanDamage < 101) && strcmpi(item->PrefixName,"Master's")==0) || ((nEnhanDamage > 200 || nEnhanDamage < 151) && strcmpi(item->PrefixName,"Grandmaster's's")==0)) {
				state = STATE_NONE;
				sprintf(DebugBuffer, "Enhanced Damage Error - %s %s %s (%d)",item->PrefixName, item->BaseName, item->SuffixName, nEnhanDamage);
				server->GamePrintString(DebugBuffer);
			}
		}
		if (strcmpi(item->BaseName,"Matriarchal Bow") != 0 && (strcmpi(item->PrefixName,"Ferocious")==0 || strcmpi(item->PrefixName,"Merciless")==0 || strcmpi(item->PrefixName,"Savage")==0 || strcmpi(item->PrefixName,"Massive")==0 || strcmpi(item->PrefixName,"Brutal")==0 || strcmpi(item->PrefixName,"Vicious")==0 || strcmpi(item->PrefixName,"Deadly")==0 || strcmpi(item->PrefixName,"Jagged")==0 || strcmpi(item->PrefixName,"Cruel")==0)){
			nEnhanDamage = GetBitsAt(Packet, Length, nAdd + 211, 9);
			if (((nEnhanDamage > 20 || nEnhanDamage < 10) && strcmpi(item->PrefixName,"Jagged")==0) || ((nEnhanDamage > 30 || nEnhanDamage < 21) && strcmpi(item->PrefixName,"Deadly")==0) || ((nEnhanDamage > 40 || nEnhanDamage < 31) && strcmpi(item->PrefixName,"Vicious")==0) || ((nEnhanDamage > 50 || nEnhanDamage < 41) && strcmpi(item->PrefixName,"Brutal")==0) || ((nEnhanDamage > 66 || nEnhanDamage < 51) && strcmpi(item->PrefixName,"Massive")==0) ||  ((nEnhanDamage > 80 || nEnhanDamage < 66) && strcmpi(item->PrefixName,"Savage")==0) || ((nEnhanDamage > 100 || nEnhanDamage < 81) && strcmpi(item->PrefixName,"Merciless")==0) || ((nEnhanDamage > 200 || nEnhanDamage < 101) && strcmpi(item->PrefixName,"Ferocious")==0) || ((nEnhanDamage > 300 || nEnhanDamage < 201) && strcmpi(item->PrefixName,"Cruel")==0)) {
				//state = STATE_NONE;
				sprintf(DebugBuffer, "Enhanced Damage Error - %s %s %s (%d)",item->PrefixName, item->BaseName, item->SuffixName, nEnhanDamage);
				server->GamePrintString(DebugBuffer);
			}
		}
		item->nEnhanDamage = nEnhanDamage;

		BYTE nSockets = 0x0;
		if (strcmpi(item->PrefixName,"Jeweler's")==0 || strcmpi(item->PrefixName,"Artisan's")==0 || strcmpi(item->PrefixName,"Mechanic's")==0 ){
			nSockets = GetBitsAt(Packet, Length, 198 + nAdd, 4);
			if (nSockets > 6) {
				state = STATE_NONE;
				sprintf(DebugBuffer, "Socket Error - %s %s %s (%d)",item->PrefixName, item->BaseName, item->SuffixName, nSockets);
				server->GamePrintString(DebugBuffer);
			}
		}
		item->nSockets = nSockets;
		
		return item;
	} else {
		delete item;
		return NULL;
	}
}

void DumpItemStruct(ITEMSTRUCT *item) {
	char DumpString[1024];
	BOOL found = false;
	sprintf(DumpString,"%s","Item: ");
	if(item->PrefixName[0] != '\0') {
		sprintf(DumpString,"%s %s",DumpString,item->PrefixName);
	}
	if(item->BaseName[0] != '\0') {
		//	server->GamePrintString("Weapon->Name is not null");
			sprintf(DumpString,"%s %s",DumpString,item->BaseName);
		
	} else {
		sprintf(DumpString,"c1 %s (%s)",DumpString,item->ItemCode); // cant lookup code!?
	}
	if(item->SuffixName[0] != '\0') {
		sprintf(DumpString,"%s %s",DumpString,item->SuffixName);
	}
	server->GamePrintString(DumpString);
	return;
	
}	
// from mousepad with some small mods
DWORD GetBitField(BYTE* data, DWORD pos, DWORD len, DWORD max) {
	// trying to read beyond the end of the packet
	if(pos + len > max) {
		// if we are already at or beyond the end of packet, return 0;
		if(pos >= max) {
			return 0;
		}
		// otherwise adjust len to all remaining bits
		len = max - pos;
	}
	return (DWORD)(*(unsigned __int64 *)(data+pos/8)<<(64-len-(pos&7))>>(64-len));
}
// modification to GetBitField by termter (termter@hanmail.ne) A really awesome Korean programmer
DWORD GetBitsAt(BYTE* data, int max, int nPos, int nLength)
{
	max = max * 8;
	if (data==NULL)
		return 0;
	if(nPos + nLength > max) {
		if(nPos >= max)
			return 0;
		nLength = max - nPos;
	}
	return (DWORD)(*(unsigned __int64 *)(data+nPos/8)<<(64-nLength-(nPos&7))>>(64-nLength));
}